//
//  vnx_lsw_api.h include file for LabBrick RF switch API
//  LSW_API
//
//  Mac OS version created by Robert Dezmelyk on 10/25/22 from LPS code base.
//  Copyright © 2008-2022 Vaunix Technology Corporation. All rights reserved.
//

#ifndef vnx_lsw_api_h
#define vnx_lsw_api_h

#include <stdbool.h>

#define TRUE true
#define FALSE false

// --------------------------------- VNX_lsw.h -------------------------------------------

// This is the declaration necessary for an imported function in a Mac OS-X dylink library
#define VNX_SWITCH_API extern

// RD -- this may not be needed...
#ifdef __cplusplus
extern "C" {
#endif
    
// ----------- Global Equates ------------
#define MAXDEVICES 64
#define MAX_MODELNAME 32
#define MAX_PATTERN_LENGTH 8

    
// ----------- Data Types ----------------
#define DEVID unsigned int
#define BYTE unsigned char

// ----------- Command Equates -----------
    
// Status returns for commands
#define LVSTATUS int

#define STATUS_OK           0
#define BAD_PARAMETER       0x80010000     // out of range input -- argument outside min/max etc.
#define BAD_HID_IO          0x80020000     // low level I/O failure, usually a USB or driver problem
#define DEVICE_NOT_READY    0x80030000     // device isn't open, no handle, etc.
#define STATUS_ERROR        0x80000000     // mask to test if we got an error

#define F_INVALID_DEVID       -1.0   // for functions that return a float
#define F_DEVICE_NOT_READY    -3.0


// Status returns for DevStatus

#define INVALID_DEVID    0x80000000   // MSB is set if the device ID is invalid
#define DEV_CONNECTED    0x00000001   // LSB is set if a device is connected
#define DEV_OPENED       0x00000002   // set if the device is opened
#define SWPAT_ACTIVE     0x00000004   // set if the device is playing a pattern
#define SWPAT_REPEATING  0x00000010   // set if the device is in repeating pattern mode

// Internal values in DevStatus
#define DEV_LOCKED       0x00000020   // Do not modify this values
#define DEV_RDTHREAD     0x00000040   // Do not modify this value

// Flags to encode pulse mode time ranges
#define PM48Mhz          0x10000000   // used to select the 48Mhz pulse mod clock
#define PM1Mhz           0x00000000   // used to select the 1Mhz pulse mod clock or sw pulsing

VNX_SWITCH_API void fnLSW_SetTraceLevel(int tracelevel, int IOtracelevel, bool verbose);
VNX_SWITCH_API void fnLSW_SetTestMode(bool testmode);
VNX_SWITCH_API int fnLSW_GetDLLVersion(void);
VNX_SWITCH_API int fnLSW_GetNumDevices(void);
VNX_SWITCH_API int fnLSW_GetDevInfo(DEVID *ActiveDevices);
VNX_SWITCH_API int fnLSW_GetModelNameA(DEVID deviceID, char *ModelName);
VNX_SWITCH_API int fnLSW_GetModelNameW(DEVID deviceID, wchar_t *Model_Name);
VNX_SWITCH_API int fnLSW_InitDevice(DEVID deviceID);
VNX_SWITCH_API int fnLSW_CloseDevice(DEVID deviceID);
VNX_SWITCH_API int fnLSW_GetSerialNumber(DEVID deviceID);

VNX_SWITCH_API int fnLSW_GetDeviceStatus(DEVID deviceID);

VNX_SWITCH_API int fnLSW_GetNumSwitches(DEVID deviceID);
VNX_SWITCH_API LVSTATUS fnLSW_SetSwitch(DEVID deviceID, int inputselect);
VNX_SWITCH_API int fnLSW_GetActiveSwitch(DEVID deviceID);
VNX_SWITCH_API int fnLSW_GetSwitchSetting(DEVID deviceID);
VNX_SWITCH_API LVSTATUS fnLSW_SetUseExternalControl(DEVID deviceID, bool external);
VNX_SWITCH_API int fnLSW_GetUseExternalControl(DEVID deviceID);
VNX_SWITCH_API LVSTATUS fnLSW_SetPulseOnTime(DEVID deviceID, float pulseontime);
VNX_SWITCH_API LVSTATUS fnLSW_SetPulseOffTime(DEVID deviceID, float pulseofftime);
VNX_SWITCH_API LVSTATUS fnLSW_EnableInternalPulseMod(DEVID deviceID, bool on);
VNX_SWITCH_API LVSTATUS fnLSW_SetFastPulsedOutput(DEVID deviceID, float pulseontime, float pulsereptime, bool on);
VNX_SWITCH_API float fnLSW_GetPulseOnTime(DEVID deviceID);
VNX_SWITCH_API float fnLSW_GetPulseOffTime(DEVID deviceID);
VNX_SWITCH_API int fnLSW_GetPulseMode(DEVID deviceID);
VNX_SWITCH_API int fnLSW_GetHasFastPulseMode(DEVID deviceID);
VNX_SWITCH_API LVSTATUS fnLSW_SetPattern(DEVID deviceID, int num_entries, int sw_select[], int holdtime[]);
VNX_SWITCH_API LVSTATUS fnLSW_SetPatternEntry(DEVID deviceID, int sw_select, int holdtime, int index, bool last_entry);
VNX_SWITCH_API LVSTATUS fnLSW_StartPattern(DEVID deviceID, bool go);
VNX_SWITCH_API LVSTATUS fnLSW_SetPatternType(DEVID deviceID, bool continuous);
VNX_SWITCH_API int fnLSW_GetPatternEntrySwitch(DEVID deviceID, int index);
VNX_SWITCH_API int fnLSW_GetPatternEntryTime(DEVID deviceID, int index);
VNX_SWITCH_API int fnLSW_GetPatternType(DEVID deviceID);
VNX_SWITCH_API int fnLSW_GetPatternLength(DEVID deviceID);

VNX_SWITCH_API LVSTATUS fnLSW_SaveSettings(DEVID deviceID);

#ifdef __cplusplus
}
#endif

#endif /* vnx_lsw_api_h */

